<?php include '3111header.php'; ?>
<!-- note: container2 and container opened in 3111header.php -->

<div id="menu"> <!--menu div opened, you can append additional menus below 3111menu.php-->
	<?php include '3111menu.php'; ?>
</div> <!--End Menu-->

<div id="more"> <!--right column limited to 160px width for content-->
	<h3>More Resources</h3>
	<p>Helpful URLs for working with MySQL and PHP</p>
	<hr>
	<ul class="disc">
	<li><a href="http://dev.mysql.com/doc/refman/5.1/en/index.html" title="MySQL 5.1 Reference Manual">MySQL 5.1 Manual</a></li>
	<li><a href="http://us3.php.net/manual/en/reserved.variables.server.php" title="PHP Server and Execution Environment Information">PHP $_SERVER Info</a></li>
	<li><a href="mysql-logview.php" title="Example Log View Page">MySQL Log View</a></li>
	</ul>
	<hr>
<!-- 	<h3>more Title</h3> -->
<!-- 	<p>more Content</p> -->
</div> <!--End More - Rt. Column-->

<div id="content"> <!--Main Content Div-->
	<h2>Create a MySQL-PHP Visitor Log</h2>
	<p>Beyond creating a counter to track the number of times your webpages have been accessed, you can also capture a number of other parameters about your site visitors such as the time of access, the IP from which the page was accessed, which browser or 'user_agent' was used, the page that was requested, and the Referrer associated with the visit, along with many more.<a class="fn" href="#fn-1" id="fnr-1" title="Footnote No. 1.">[1]</a> If you would like to capture additional information, simply make the necessary additions as we go through the setup.</p>
	<p class="note">Throughout the examples contained in this page I will use the following names for the MySQL database, the user, the password and table:<br><br>
	<strong>MySQL database:</strong> &nbsp;&nbsp;web<br>
	<strong>database user:</strong> &nbsp;&nbsp;web-user<br>
	<strong>database password:</strong> &nbsp;&nbsp;password<br>
	<strong>MySQL table:</strong> &nbsp;&nbsp;log<br><br>
	** This will allow generic access to your table using &quot;web.log&quot; notation.</p>
	<h3>Secure Your MySQL Installation</h3>
	<p>If you have not already done so, the very first thing that you must do is to secure your mysql installation by creating a root password and setting up users. See my server setup, Sect. 4: <a href="http://www.3111skyline.com/linux/openSuSE-server.php#mysql">Securing MySQL</a> and complete before continuing.</p>
	<h3>Creating the database, web-user and table</h3>
	<p>Given that your web server will be feeding your database and while I have every confidence in the security of apache2, php and mysql, why risk compromise of an important database. We'll create a new one for handling your web information. Being overly creative, let's just call the database -- web.</p>
	<h4>Creating the MySQL database and user</h4>
	<p>For creating databases and granting privileges to users, I just log into MySQL and do it manually. First let's create the <strong>web</strong> database (or whatever you want to call your database):</p>
<pre>
19:35 ecstasy:~&gt; mysql -uroot -p
mysql&gt; create database web;
</pre>
	<p class="note">To exit mysql, simply type quit or exit. The remaining examples assume you can log into  mysql to reach the &quot;mysql&gt;&quot; prompt. Above the &quot;19:35 ecstasy:~&gt;&quot; is simply my BASH prompt.</p>
	<p>Next, let's create the <strong>web-user</strong> (or whatever you wish to call the user) and limit access to the database to your web-user at localhost:</p>
<pre>
mysql&gt; GRANT ALL PRIVILEGES ON web.* TO 'web-user'@'localhost' IDENTIFIED BY 'password';
mysql&gt; GRANT ALL PRIVILEGES ON web.* TO 'web-user'@'127.0.0.1' IDENTIFIED BY 'password';
</pre>
	<p class="note">If your webserver resides on the same host as your mysql database, then you only need to create privileges for your web-user on localhost and 127.0.0.1. If your webserver is on a separate machine make sure you also grant privileges to <u>'web-user'@'yourwebhost.yourdomain'</u>.</p>
	<h4>Creating the Table to Hold Your Data</h4>
	<p>Creating the mysql table to hold the information concerning web site visitors is quite easy. You can do it from within MySQL or from the command line. The easiest way to do this (my favorite) is first to create a text file (example: weblogdef) containing the table definition for the log table:</p>
<pre>
Create Table: CREATE TABLE `log` (
  `ID` int(8) NOT NULL auto_increment,
  `Date` datetime NOT NULL default '0000-00-00 00:00:00',
  `IP` varchar(20) NOT NULL default '',
  `User_Agent` varchar(255) NOT NULL default '',
  `Request_URI` varchar(255) NOT NULL default '',
  `Page` varchar(255) NOT NULL default '',
  `Referer` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1
</pre>
	<p>Then to add the table to your <strong>web</strong> database, simply use the mysql command from the command line:</p>
<pre>
19:37 ecstasy:~&gt; mysql -u &lt;web-user&gt; -p &lt;password&gt; web &lt; weblogdef
</pre>
	<p class="note">replace &lt;web-user&gt; with the actual user and replace &lt;password&gt; with the actual password.</p>
	<p>Your MySQL database is now fully configured.</p>
	<h3>The PHP Code to Make it Work</h3>
	<p>Next, we need to write the PHP code that will capture the information we want and write that data to our database. We will make use of the php superglobal variable $_SERVER as any use of the global variables $HTTP_SERVER_VARS poses significant security risk and is now deprecated. Additionally, we need to figure out where we will put the code so that it is executed each time someone visits our site. I have placed the code as the first entry after the &lt;body&gt; tag in my pages.</p>
	<p>To make all my page creation as simple as possible, I have broken my pages up into separate files where I have a header.php, menu.php, content.php, and footer.php.<a class="fn" href="#fn-2" id="fnr-2" title="Footnote No. 2.">[2]</a> Since the &lt;body&gt; tag is actually opened in my header.php, all that was required was adding the php code to my header.php and the visitor log was automatically added to every page in my site. The code you will need to add is:</p>
<pre>
&lt;?php

// MySQL Connection Information
$host="localhost";
$database="web";
$user="web-user";
$password="password";

// Retrieve Connection Information
$ip = $_SERVER['REMOTE_ADDR'];
$user_agent = $_SERVER['HTTP_USER_AGENT'];
$request_uri = $_SERVER['REQUEST_URI'];
$page = 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
$referer = $_SERVER['HTTP_REFERER'];

// Connect to database and Insert Information
$connection = mysql_connect($host,$user,$password)
    or die ("Couldn't connect to server");
$db = mysql_select_db($database,$connection)
    or die ("Couldn't select database");
$query = mysql_query("INSERT INTO log VALUES ('',now(),'$ip','$user_agent','$request_uri','$page','$referer')");

?&gt;
</pre>
	<p class="note">The php code above should be self explanatory. The only noteworthy item is the $query statement. Note that the auto_increment value is simply specified as '', and that the page access time utilizes the php now() function. The remainer of the values are just the values returned by the superglobal $_SERVER.</p>
	<p>If you have included the code above in the &lt;body&gt; section of your web page, then the next time you access the page the information you specified should be written to your web database.</p>
	<h3>Testing and Troubleshooting</h3>
	<p>Of course before you turn anything loose on your website, you should test it and confirm it is working as expected. The easiest way to test the function of your new log is to call a test page the will dump the information that you are writing to the database so you can confirm you actually have the information you are trying to write to the database. I created a simple test page for this purpose: <a href="/download/webdev/snippets/pop-logtest" onClick="return popup(this, 'LogTest')">Sample Test Page for Visitor Log</a> Simply save the file into a directory accessible by your web server as logtest.php and then access the page. If you see all the variables (except you won't have a referrer) then you have all the data available to you.</p>
	<p>Next, check the database to make sure it has been updated. Let's just use mysql to have a look at the last record that was added to the database. You should see something similar to the following:</p>
<pre>
mysql&gt; select * from log order by ID desc limit 1;
+----+---------------------+-----------+----------------------------------------------------+--------------------------------------+------------------------------------------------------+---------+
| ID | Date                | IP        | User_Agent                                         | Request_URI                          | Page                                                 | Referer |
+----+---------------------+-----------+----------------------------------------------------+--------------------------------------+------------------------------------------------------+---------+
| 42 | 2009-01-11 20:57:19 | 127.0.0.1 | Opera/9.63 (X11; Linux x86_64; U; en) Presto/2.1.1 | /download/webdev/pages/mysql-log.php | http://localhost/download/webdev/pages/mysql-log.php |         |
+----+---------------------+-----------+----------------------------------------------------+--------------------------------------+------------------------------------------------------+---------+
</pre>
	<p>You can also create a formatted page to show just those fields you would like to see from your web.log table. I have created an example that displays the last 50 pages that were accessed in my log here as an example. See the "MySQL Log View" link in the right-column or simply click the link here: <a href="mysql-logview.php" title="Example Log View Page">MySQL Log View</a></p>
	<p>If all has gone well and you have confirmed that your database is in fact being updated, then you can safely turn the visitor log loose on your website. If your database isn't being updated, then the test page has given you all the information you need to sort out where the problem is. If you don't have any data displayed on the testpage -- your problem is with php. If you have output, but your database isn't being updated or you are getting the "Couldn't connect to server" error, then your problem is with MySQL. Go back and recheck your work and you will find your problem.</p>
	<h3>Added Security</h3>
	<p>One final note on security. It is always a good idea to separate any content containing credentials from the actual web pages that get called from the internet, and instead, place the credentials in a file in a directory that is not accessible by the web server, and then use the php include function to access that information.</p>
	<p>A simple way to do this is to create a new directory under your "Server Root" but outside your "Document Root". If you don't know where these are on your server, you can check with phpinfo(); either from the command line ( php5 phpinfo(); ) or from within any web page ( &lt;?php phpinfo(); ?&gt; ). On the redhat style distros, the Server Root is generally /var/www, on openSuSE it's /srv/www.</p>
	<p>Create a directory off the Server Root (say: /srv/www/data) and give it permissions of no more than 0750 and change the group so that it is accessible by the webserver. For example 'chown root:www /srv/www/data'. Then move the php code above to a file under that directory (/srv/www/data/mysql-log.php) with the same limited permissions and ownership and replace the code in the &lt;body&gt; section of your document with &lt;?php include '/srv/www/data/mysql-log.php'; ?&gt;. A little added security never hurts.</p>
	<h4>Good Luck!</h4>

<!-- Footnote References: Use Inline with Content-->
<!-- <a class="fn" href="#fn-3" id="fnr-3" title="Footnote No. 3.">[3]</a> -->
<!-- <a class="fn" href="#fn-4" id="fnr-4" title="Footnote No. 4.">[4]</a> -->
<!-- Content - Footnotes Section: Leave at End of Document-->
<hr class="fnr">
<ol class="fnr">
	<li><a class="fnr" href="#fnr-1" id="fn-1" title="Return to location in document">PHP.net $_SERVER <a href="http://us3.php.net/manual/en/reserved.variables.server.php" alt="Server and Execution Environment Information" title="PHP Server and Execution Environment Information">PHP Server and Execution Environment Information</a></a></li>
	<li><a class="fnr" href="#fnr-2" id="fn-2" title="Return to location in document">I have made the complete template for this site available as a download. An example page showing the template and the gzipped archive for download are available: <a href="index.php" title="Complete 3-Column Website Template">Website Template</a>.</a></li>
<!-- 	<li><a class="fnr" href="#fnr-3" id="fn-3" title="Return to location in document">Footnote 3 Text.</a></li> -->
<!-- 	<li><a class="fnr" href="#fnr-4" id="fn-4" title="Return to location in document">Footnote 4 Text.</a></li> -->
</ol>

</div> <!--End content div-->
<?php include '3111cleardiv.php'; ?>
</div> <!--End container2-->
</div> <!--End container-->
<?php include '3111footer.php'; ?>
